﻿using System;
using OpcLabs.EasyOpc.OperationModel;
using OpcLabs.EasyOpc.UA;
using OpcLabs.EasyOpc.UA.Engine;
using OpcLabs.EasyOpc.UA.OperationModel;

namespace ConsoleApp
{
    internal sealed class Program
    {
        private const string ServerEndpoint = "to be specified";
        private const string OpcUaNode = "to be specified";

        private static void Main()
        {
            Console.WriteLine("Starting");

            SetUpQuickOpc();
            
            bool couldRead = RunTest();
            
            Console.WriteLine($"Success: {couldRead}");
        }

private static void SetUpQuickOpc()
{
    EasyUAClient.SharedParameters.EngineParameters
        .CertificateAcceptancePolicy = UACertificateAcceptancePolicy.TestingInsecure;
        
    EasyUAClient.SharedParameters.EngineParameters.ConfigurationSources = UAConfigurationSources.AppConfig;

    EasyUAClient.LogEntry += (_, args) =>
        Console.WriteLine($"EasyUAClient message args: {args}");
}
        
        private static bool RunTest()
        {
            var easyUaClient = new EasyUAClient
            {
                Isolated = true
            };

            var endpointDescriptor = new UAEndpointDescriptor(ServerEndpoint);
            var nodeDescriptor = new UANodeDescriptor(OpcUaNode);

            UAAttributeData readResult;
            try
            {
                readResult = easyUaClient.Read(endpointDescriptor, nodeDescriptor);
            }
            catch (Exception e) when (e is OpcException or UAException)
            {
                Console.WriteLine(e);
                return false;
            }
            
            if (!readResult.HasValue)
            {
                return false;
            }

            if (readResult.HasBadStatus || readResult.HasUncertainStatus)
            {
                return false;
            }

            bool boolResult = (bool)readResult!.Value!;
            Console.WriteLine($"Bool result: {boolResult}");
            
            return true;
        }
    }
}