﻿' $Header: $
' Copyright (c) CODE Consulting and Development, s.r.o., Plzen. All rights reserved.

' ReSharper disable CheckNamespace
#Region "Example"
' This example shows how to obtain all leaves under the "Simulation" branch of the address space. For each leaf, it displays 
' the ItemID of the node.
'
' Find all latest examples here: https://opclabs.doc-that.com/files/onlinedocs/OPCLabs-ConnectivityStudio/Latest/examples.html .
' OPC client and subscriber examples in VB.NET on GitHub: https://github.com/OPCLabs/Examples-ConnectivityStudio-VBNET .
' Missing some example? Ask us for it on our Online Forums, https://www.opclabs.com/forum/index ! You do not have to own
' a commercial license in order to use Online Forums, and we reply to every post.

Imports OpcLabs.EasyOpc
Imports OpcLabs.EasyOpc.DataAccess
Imports OpcLabs.EasyOpc.DataAccess.AddressSpace
Imports OpcLabs.EasyOpc.OperationModel

Namespace Global.DocExamples.DataAccess.Xml
    Partial Friend Class BrowseLeaves
        Shared Sub Main1Xml()
            Dim client = New EasyDAClient()

            Dim leafElements As DANodeElementCollection
            Try
                Dim serverDescriptor As ServerDescriptor = "http://opcxml.demo-this.com/XmlDaSampleServer/Service.asmx"
                leafElements = client.BrowseLeaves(serverDescriptor, "Static/Analog Types")
            Catch opcException As OpcException
                Console.WriteLine("*** Failure: {0}", opcException.GetBaseException().Message)
                Exit Sub
            End Try

            For Each leafElement In leafElements
                Console.WriteLine($"LeafElements(""{leafElement.Name}"").ItemId: {leafElement.ItemId}")
            Next leafElement

        End Sub

        ' Example output
        '
        'LeafElements("Int").ItemId: Static/Analog Types/Int
        'LeafElements("Double").ItemId: Static/Analog Types/Double
        'LeafElements("Int[]").ItemId: Static/Analog Types/Int[]
        'LeafElements("Double[]").ItemId: Static/Analog Types/Double[]

    End Class
End Namespace
#End Region
