﻿# $Header: $
# Copyright (c) CODE Consulting and Development, s.r.o., Plzen. All rights reserved.

#region Example
# This example shows how to react to events in order to initiate and finalize data collection in the push data provision
# model.
# You can use any OPC UA client, including our Connectivity Explorer and OpcCmd utility, to connect to the server. 
#
# Find all latest examples here: https://opclabs.doc-that.com/files/onlinedocs/OPCLabs-OpcStudio/Latest/examples.html .
# OPC client, server and subscriber examples in C# on GitHub: https://github.com/OPCLabs/Examples-ConnectivityStudio-CSharp .
# Missing some example? Ask us for it on our Online Forums, https://www.opclabs.com/forum/index ! You do not have to own
# a commercial license in order to use Online Forums, and we reply to every post.

#requires -Version 5.1
using namespace OpcLabs.EasyOpc.UA
using namespace OpcLabs.EasyOpc.UA.NodeSpace

# The path below assumes that the current directory is [ProductDir]/Examples-NET/PowerShell/Windows .
Add-Type -Path "../../../Components/Opclabs.QuickOpc/net472/OpcLabs.ServerOpcUAComponents.dll"

# Instantiate the server object.
# By default, the server will run on endpoint URL "opc.tcp://localhost:48040/".
$server = New-Object EasyUAServer

# Create a read-only data variable.
$dataVariable = [UADataVariableExtension]::Writable([UADataVariableExtension]::ValueType([UADataVariable]::CreateIn($server.Objects, "ReadThisVariable"), [int]), $false)

$random = New-Object System.Random

Register-ObjectEvent -InputObject $dataVariable -EventName Starting -Action {
    param ($sender, $e) 
    # Create a timer for pushing the data for OPC reads.
    $timer = New-Object Timers.Timer -property @{
        Interval = 1000
        AutoReset = $true
    }

    # Set the read attribute data of the data variable to a random value whenever the timer interval elapses.
    # Note that this example shows the basic concept, however there is also an UpdateReadAttributeData method that
    # can be used in most cases to achieve slightly more concise code.
    Register-ObjectEvent -InputObject $timer -EventName Elapsed -Action { 
        param ($sender, $e)
        $dataVariable.ReadAttributeData = New-Object UAAttributeData($random.Next(), [DateTime]::UtcNow) 
    }

    # Associate the timer with the data variable.
    $dataVariable.State = $timer

    $timer.Start()
}

Register-ObjectEvent -InputObject $dataVariable -EventName Stopped -Action { 
    param ($sender, $e) 
    # Obtain the timer associated with the data variable.
    $timer = [Timers.Timer](([UADataVariable]$sender).State)

    # Stop the timer.
    $timer.Stop()
}

# Start the server.
Write-Host "The server is starting..."
$server.Start()

Write-Host "The server is started."
Write-Host

# Let the user decide when to stop.
Write-Host "Press Enter to stop the server..."
while(![System.Console]::KeyAvailable) { Start-Sleep -Milliseconds 20 }
[void][System.Console]::ReadKey()

# Stop the server.
Write-Host "The server is stopping..."
$server.Stop()

Write-Host "The server is stopped."
#endregion Example
