﻿// $Header: $
// Copyright (c) CODE Consulting and Development, s.r.o., Plzen. All rights reserved.

// UAConsoleApplication1: The simplest console application. Reads and displays an OPC-UA node value.
//
// Find all latest examples here: https://opclabs.doc-that.com/files/onlinedocs/OPCLabs-ConnectivityStudio/Latest/examples.html .
// Missing some example? Ask us for it on our Online Forums, https://www.opclabs.com/forum/index ! You do not have to own
// a commercial license in order to use Online Forums, and we reply to every post.

open OpcLabs.EasyOpc.UA
open System

let endpointDescriptor =
    new UAEndpointDescriptor("opc.tcp://opcua.demo-this.com:51210/UA/SampleServer")
    // or "http://opcua.demo-this.com:51211/UA/SampleServer" (currently not supported)
    // or "https://opcua.demo-this.com:51212/UA/SampleServer/"

Console.WriteLine "Instantiating the client object..."
let client = new EasyUAClient()

Console.WriteLine "Reading node..."
let value = 
    client.ReadValue(
        endpointDescriptor,
        new UANodeDescriptor("nsu=http://test.org/UA/Data/;i=10853"))

Console.WriteLine "Displaying results..."
Console.WriteLine value

Console.WriteLine "Press Enter to continue..."
Console.ReadLine() |> ignore
