﻿// $Header: $
// Copyright (c) CODE Consulting and Development, s.r.o., Plzen. All rights reserved.

// ReSharper disable AccessToStaticMemberViaDerivedType
// ReSharper disable ArrangeModifiersOrder
// ReSharper disable RedundantCommaInArrayInitializer
// ReSharper disable LocalizableElement

using System;
using System.Collections.Generic;
using OpcLabs.BaseLib.Console;
using OpcLabs.EasyOpc.UA;
using OpcLabs.EasyOpc.UA.Engine;

namespace UAServerDocExamples.Licensing
{
    static class LicensingExamplesMenu
    {
        public static void Main1()
        {
            var actionArray = new Action[] {
                _LicensingManagement.RegisterManagedResource,
                _LicensingManagement.RegisterManagedResourceWithExistenceCheck,
                LicenseInfo.AllFields,
                LicenseInfo.SerialNumber,
            };

            var actionList = new List<Action>(actionArray);

            var originalSharedParameters = (EasyUAServerSharedParameters)EasyUAServer.SharedParameters.Clone();
            do
            {
                Console.WriteLine();
                if (!ConsoleDialog.SelectAndPerformAction("Select action to perform", "Return", actionList))
                    break;

                Console.WriteLine("Press Enter to continue...");
                Console.ReadLine();

                if (EasyUAServer.SharedParameters != originalSharedParameters)
                {
                    using (ConsoleUtilities.WithForegroundColor(ConsoleColor.Yellow))
                        Console.WriteLine(
                            "This example has changed some global parameters that can influence how other examples work. " +
                            "For this reason, the application will now exit. Start it again to continue.");
                    Console.WriteLine("Press Enter to continue...");
                    Console.ReadLine();
                    Environment.Exit(0);
                }
            }
            while (true);
        }
    }
}
